<?php include '../concha.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?php echo $nombresitio; ?> – Radio</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- PWA -->
  <link rel="manifest" href="manifest.php">
  <meta name="theme-color" content="<?php echo $d_color_titulo; ?>">
  <link rel="apple-touch-icon" href="icon-192.png">
  <link rel="icon" href="icon-192.png">

  <!-- Estilos y fuentes -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;700&display=swap" rel="stylesheet">
  <script src="https://kit.fontawesome.com/08c7c8fb48.js" crossorigin="anonymous"></script>

  <style>
    body {
      background: <?php echo $d_color_titulo; ?>;
      color: #fff;
      font-family: 'Poppins', sans-serif;
      height: 100vh;
      margin: 0;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
    }

    h1 {
      font-size: 1.8rem;
      margin-bottom: 2rem;
    }

    #playBtn {
      font-size: 4rem;
      width: 110px;
      height: 110px;
      border-radius: 50%;
      border: 4px solid #fff;
      color: #fff;
      background: transparent;
      display: flex;
      justify-content: center;
      align-items: center;
      transition: all 0.3s;
    }

    #playBtn:hover {
      background: #fff;
      color: <?php echo $d_color_titulo; ?>;
    }

    #offlineMsg {
      display: none;
      margin-top: 1.5rem;
      font-size: 1rem;
      color: #fff;
    }
  </style>
</head>
<body>

<img src="icon-512.png" alt="Icono del sitio" class="img-fluid mb-3" style="max-width: 120px;">
<h1><?php echo $nombresitio; ?></h1>


<button id="playBtn"><i class="fas fa-play"></i></button>
<div id="offlineMsg">Sin conexión 😕</div>

<audio id="player" preload="none" src="<?php echo $ip_stream; ?>"></audio>

<!-- Modal instalación -->
<div class="modal fade" id="installModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content bg-dark text-white border-light">
      <div class="modal-header border-0">
        <h5 class="modal-title"><i class="fas fa-download me-2"></i>Instalá la App</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p>Agregá esta radio a tu inicio para acceder más fácil.</p>
        <div id="iosTip" class="d-none">
          <p>En <strong>iOS</strong> tocá <i class="fas fa-share-square"></i> y luego “Agregar a inicio”.</p>
        </div>
        <button id="installBtn" class="btn btn-light w-100 d-none">Instalar</button>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
if ('serviceWorker' in navigator) {
  navigator.serviceWorker.register('sw.js');
}

const player = document.getElementById('player');
const btn = document.getElementById('playBtn');
btn.addEventListener('click', () => {
  if (player.paused) {
    player.play();
    btn.innerHTML = '<i class="fas fa-pause"></i>';
  } else {
    player.pause();
    btn.innerHTML = '<i class="fas fa-play"></i>';
  }
});

const offlineMsg = document.getElementById('offlineMsg');
function updateOnlineStatus() {
  offlineMsg.style.display = navigator.onLine ? 'none' : 'block';
  if (!navigator.onLine) {
    player.pause();
    btn.innerHTML = '<i class="fas fa-play"></i>';
  }
}
window.addEventListener('online', updateOnlineStatus);
window.addEventListener('offline', updateOnlineStatus);
updateOnlineStatus();

let deferredPrompt = null;
const installModal = new bootstrap.Modal(document.getElementById('installModal'));
const installBtn = document.getElementById('installBtn');
const iosTip = document.getElementById('iosTip');
const isIOS = /iphone|ipad|ipod/i.test(navigator.userAgent);

window.addEventListener('load', () => {
  if (isIOS) {
    iosTip.classList.remove('d-none');
    installModal.show();
  }
});

window.addEventListener('beforeinstallprompt', (e) => {
  e.preventDefault();
  deferredPrompt = e;
  installBtn.classList.remove('d-none');
  installModal.show();
});

installBtn.addEventListener('click', async () => {
  if (!deferredPrompt) return;
  deferredPrompt.prompt();
  const { outcome } = await deferredPrompt.userChoice;
  if (outcome === 'accepted') installModal.hide();
  deferredPrompt = null;
});
</script>
</body>
</html>
